/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   MotoTronSpecific Error Definitions
::   Copyright   :   (C)2003-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::   $Workfile:      MotoTronSpecificError.h $
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

/*! \file MotoTronSpecificError.h
 \brief Defines the error codes used by the MotoTronSpecific archive.  
 
MotoTronSpecific Error definitions to be exposed to the application.  All errors are defined to fit into 
the signed integer format for the chosen platform. The error code is constructed with a number of fields. 
The size of the fields and their members is dependant upon what the platform's native integer size is and 
how the information is to be employed.  Always use the SUCCESS and FAILURE macros to test on an error
*/

#ifndef __MOTOTRONSPECIFICERROR_H
#define __MOTOTRONSPECIFICERROR_H

#include <NativeError.h>
#include <BitFunctions.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)
/* Name: E_MotoTronSpecificError ClassID:ENUMDEC EnumDflt:"Illegal Error" */
typedef enum
{
    MOTOTRONSPECIFICERROR_NONE,                    /* EnumTxt:"Normal Operation"*/
    MOTOSECURITY_ARCHIVE_REGISTERED,               /* EnumTxt:"MotoTronSpecific Archive Already Registered" */
    MISSING_SECURITY_ATTRIBUTE,                    /* EnumTxt:"Missing MotoSecurity Attribute" */
    SECURITY_ATTRIBUTE_INVALID,                    /* EnumTxt:"MotoSecurity Parameters Invalid" */

    NUM_NATIVE_MOTOTRONSPECIFIC_ERRORS
} E_MotoTronSpecificError;
#define NUM_MOTOTRONSPECIFIC_ERROR_PARENTS          (((NUM_NATIVE_MOTOTRONSPECIFIC_ERRORS-1)/ELEMENTS_PER_PARENT)+1)

/* Name: E_MotoTronSpecificSuccess ClassID:ENUMDEC EnumDflt:"Illegal Success" */
typedef enum
{
    MOTOTRONSPECIFIC_ARCHIVE_OK,                    /* EnumTxt:"MotoTronSpecific Operation Successful"*/

    NUM_NATIVE_MOTOTRONSPECIFIC_SUCCESSES
} E_MotoTronSpecificSuccess;

/* Native Error Field1 Definitions to be used in the context of the MotoTronSpecific_MODULE */
typedef enum
{
    MOTOTRONSPECIFIC_API,

    NUM_MOTOTRONSPECIFIC_SUBSYSTEMS
} E_MotoTronSpecificSubSystem;
#pragma pack()

/***********************************************************************************************************/
/** MOTOTRONSPECIFIC_MODULE    *****************************************************************************/
/** API           ******************************************************************************************/
/** SUCCESS CODES ******************************************************************************************/
/***********************************************************************************************************/
/* Create a MOTOTRONSPECIFIC_API Success Value */
#define CREATE_MOTOTRONSPECIFIC_API_SUCCESS_VALUE(A)            CREATE_SUCCESS_DEFINE_VALUE(MOTOTRONSPECIFIC_API,MOTOTRON_SPECIFIC,A)

/*! MOTOTRONSPECIFIC_ARCHIVE_OK:                              
    The MotoTronSpecific API call executed successfully.    */
#define SUCCESS_MOTOTRONSPECIFIC_ARCHIVE_OK                     CREATE_MOTOTRONSPECIFIC_API_SUCCESS_VALUE(MOTOTRONSPECIFIC_ARCHIVE_OK)

/***********************************************************************************************************/
/** MOTOTRONSPECIFIC_MODULE    *****************************************************************************/
/** API           ******************************************************************************************/
/** ERRORS                **********************************************************************************/
/***********************************************************************************************************/
/* Create a MotoTronSpecific_API Error Value */
#define CREATE_MOTOTRONSPECIFIC_API_ERROR_VALUE(A)              CREATE_ERROR_DEFINE_VALUE(MOTOTRONSPECIFIC_API,MOTOTRON_SPECIFIC,A)

/*! ERROR_MOTOSECURITY_ARCHIVE_REGISTERED:                                                                         
    Attempt to register the MotoTronSpecific archive multiple times. */
#define ERROR_MOTOSECURITY_ARCHIVE_REGISTERED                   CREATE_MOTOTRONSPECIFIC_API_ERROR_VALUE(MOTOSECURITY_ARCHIVE_REGISTERED)

/*! ERROR_MISSING_SECURITY_ATTRIBUTE:                                                                         
    Attempt to register MotoSecurity components without supplying the required number of security components. */
#define ERROR_MISSING_SECURITY_ATTRIBUTE                        CREATE_MOTOTRONSPECIFIC_API_ERROR_VALUE(MISSING_SECURITY_ATTRIBUTE)

/*! ERROR_SECURITY_ATTRIBUTE_INVALID:                                                                         
    Attempt to register MotoTron secrity parameters which are invalid. */
#define ERROR_SECURITY_ATTRIBUTE_INVALID                        CREATE_MOTOTRONSPECIFIC_API_ERROR_VALUE(SECURITY_ATTRIBUTE_INVALID)


/*---- VARDECS --------------------------------------------------------------------------------------------*/


/*---- PROTOTYPES -----------------------------------------------------------------------------------------*/


#endif /* __MOTOTRONSPECIFICERROR_H */
/*---- END OF FILE ----------------------------------------------------------------------------------------*/


